<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth as FacadesAuth;

class LoginController extends Controller
{
    function index(){
        return view('login.login');
    }

    function login(Request $request){
        $request->validate([
            'username' => 'required',
            'password' => 'required'
        ],
        [
            'username.required' => 'Username wajib diisi',
            'password.required' => 'Password wajib diisi'
        ]);

        $infologin = [
            'name' => $request->username,
            'password' => $request->password
        ];

        if(FacadesAuth::attempt($infologin)){
            return redirect('/admin/dashboard');
        }else{
            return redirect('/admin')->withErrors('username atau password salah')->withInput();
        }
    }

    function logout(){
        FacadesAuth::logout();
        return redirect('/admin');
    }
}
