<?php

namespace App\Http\Controllers;

use App\Models\post;

use App\Models\produk;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class PublicDataController extends Controller
{
    public function index() {
        $data = post::orderBy('created_at', 'desc')->paginate(6);
        return view('pages.berita', compact('data'));
    }

    public function theProduct() {
        $data_berita = post::orderBy('created_at', 'desc')->take(3)->get();
        return view('pages.beranda', compact('data_berita'));
    }

    public function show($slug) {
        $data = post::where('slug', $slug)->firstOrFail();
        $dataBerita = post::orderBy('created_at', 'desc')->paginate(3);
        return view('pages.artikel', compact('data', 'dataBerita'));
    }

    public function filterTag($tag) {
        $dataTag = $tag;
        $data = post::where('tags', 'like', "%$tag%")->orderBy('created_at', 'desc')->paginate(6);
        return view('pages.tag', compact('data', 'dataTag'));
    }

    public function kontak() {
        return view('pages.kontak');
    }

}
