<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="{{ asset('/assets/css/font-awesome.min.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-gH2yIJqKdNHPEq0n4Mqa/HGKIhSkIHeL5AyhkYV8i59U5AR6csBvApHHNl/vI1Bx" crossorigin="anonymous">
    <style>
        .container {
            position: fixed;
            width: 400px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .back:hover {
            color: #4d82d2;
        }

        @media screen and (max-width:440px){
            .container {
                width: 90%;
            }
        }

    </style>
    <title>Diskumperindag || Login</title>
</head>
<body>
    <div class="container py-5">
        <div class="w-5 center border rounded px-3 py-3 mx-auto">
        <h1 class="text-center">LOGIN</h1>
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form action="{{ route('login') }}" method="POST">
            @csrf
            <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" value="{{ old('username') }}" name="username" class="form-control" required>
            </div>
            <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <div class="input-group">
            <input type="password" name="password" id="password" class="form-control" required>
            <button type="button" class="btn border-0" id="togglePassword" style="outline: none;">
            <i class="fa fa-eye-slash" id="togglePasswordIcon"></i>
            </button>
            </div>
            </div>
            <div class="mb-3 d-grid">
            <button name="submit" type="submit" class="btn btn-primary">Login</button>
            <a href="/" class="back text-decoration-none m-3 text-center">Kembali ke Website</a>
            </div>
        </form>
        <script>
            document.getElementById('togglePassword').addEventListener('click', function () {
            const passwordField = document.getElementById('password');
            const passwordIcon = document.getElementById('togglePasswordIcon');
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            passwordIcon.classList.toggle('fa-eye');
            passwordIcon.classList.toggle('fa-eye-slash');
            });
        </script>
    </div>
    </div>
    <script src="{{ asset('assets/js/jquery.js') }}"></script>
    <script src="{{ asset('/assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('/assets/js/bootsnav.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>
</body>
</html>
