<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\DataController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\ProfilController;
use App\Http\Controllers\PublicDataController;

Route::get('/', [PublicDataController::class, "theProduct"]);

Route::get('/clear', function() {
    Artisan::call('optimize:clear');
    return view('/');
});

Route::get('/storage', function () {
    Artisan::call('storage:link');
    return view('/');
});

Route::get('/galeri', function () {
    return view('pages.galeri');
});

Route::get('/berita', [PublicDataController::class, "index"]);

Route::get('/berita/{slug}', [PublicDataController::class, "show"]);

Route::get('/berita/tags/{tag}', [PublicDataController::class, "filterTag"]);

Route::get("/kontak", [PublicDataController::class,"kontak"]);


Route::middleware('guest')->group(function () {
    Route::get('/admin', [LoginController::class, "index"])->name('login');
    Route::post('/admin', [LoginController::class, "login"]);
});

Route::get('/home', function () {
    return redirect('/admin/dashboard');
});

Route::middleware('auth')->group(function () {
    Route::get('/admin/dashboard', [DataController::class, "index"]);
    Route::get('/admin/profile', [ProfilController::class, "index"]);
    Route::resource('data', DataController::class);
    Route::resource('profile', ProfilController::class);
    Route::get('/logout', [LoginController::class, "logout"]);
});

// Apply rate limiting to prevent brute force attacks
Route::middleware('throttle:60,1')->group(function () {
    Route::post('/admin', [LoginController::class, "login"]);
});
