

<?php $__env->startSection('content'); ?>
<div class="main-panel">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-tasks">

                        <div class="card-header col-md-12 d-flex justify-content-between align-items-center">
                            <h4 class="card-title">Data Berita</h4>
                            <form class="navbar-right navbar-form nav-search" class="form-inline" method="GET" action="/admin/dashboard/">
                                <div class="input-group">
                                    <input type="search" id="searchTable" name="searchTable" placeholder="Cari..." aria-label="search" value="<?php echo e(request()->get('searchTable')); ?>" class="form-control">
                                    <div class="input-group-append">
                                        <button class="border-0" type="submit" style="outline: none; box-shadow: none; background: transparent;">
                                            <i class="la la-search search-icon"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <div id="lookup" style="padding: 15px 15px;" class="text-right">
                            <form action="/admin/dashboard" method="GET">
                                <button class="btn btn-outline-success my-sm-0" type="submit">
                                    <i class="la la-refresh" style="font-size: 1.5em;"></i>
                                </button>
                            </form>
                        </div>


                        <div class="card-body">
                            <div class="table-full-width" style="overflow-y: scroll; overflow-x:auto;">
                                <table class="table table-bordered" id="dataTable">
                                    <thead class="text-center">
                                        <tr>
                                            <th>No</th>
                                            <th>Judul</th>
                                            <th>Gambar</th>
                                            <th>Deskripsi</th>
                                            <th>Tag</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration + ($data->currentPage() - 1) * $data->perPage()); ?></td>

                                            <td style="width: 20%"><?php echo e($dt->title); ?></td>

                                            <td style="width: 10%" class="text-center"><img src="<?php echo e(asset('storage/img/'.$dt->photo)); ?>" style="object-fit: cover;" width="50" height="50"></td>

                                            <td style="
                                            width: 40%;"><textarea class="form-control"  rows="3"><?php echo e($dt->data); ?></textarea></td>

                                            <td style="width: 20%" class="text-center"><?php echo e($dt->tags); ?> </td>

                                            <td style="width: 10%" class="td-actions text-center">
                                                <div class="form-button-action">

                                                    <a href="<?php echo e(route('data.edit', $dt->id)); ?>" data-toggle="tooltip" title="Edit Data" class="btn btn-link btn-simple-primary">
                                                        <i class="la la-edit"></i>
                                                    </a>

                                                    <form method="POST" action="<?php echo e(route('data.destroy', $dt->id)); ?>" onsubmit="return confirm('Hapus Data?');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" data-toggle="tooltip" title="hapus" class="btn btn-link btn-simple-danger">
                                                            <i class="la la-times"></i>
                                                        </button>
                                                    </form>

                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                            </div>
                            <div class="pagination-container d-flex justify-content-center align-items-center">
                                <?php if($data->onFirstPage()): ?>
                                    <button class="btn btn-secondary" disabled>Selanjutnya</button>
                                <?php else: ?>
                                    <a href="<?php echo e($data->previousPageUrl()); ?>" class="btn btn-primary">Selanjutnya</a>
                                <?php endif; ?>

                                <span class="mx-3 text-center">
                                    Menampilkan Total <?php echo e($data->firstItem()); ?> - <?php echo e($data->lastItem()); ?> dari <?php echo e($data->total()); ?> Data
                                </span>

                                <?php if($data->hasMorePages()): ?>
                                    <a href="<?php echo e($data->nextPageUrl()); ?>" class="btn btn-primary">Sebelumnya</a>
                                <?php else: ?>
                                    <button class="btn btn-secondary" disabled>Sebelumnya</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <form action="<?php echo e(url('data')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Berita Baru</h4>
                                        
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="title">Judul</label>
                                            <input type="text" class="form-control" id="title" name="title" placeholder="Masukkan Judul" required>
                                        </div>

                                        <?php if(session('error')): ?>
                                            <div class="alert alert-danger" id="error-alert">
                                                <?php echo e(session('error')); ?>

                                            </div>
                                            <script>
                                                alert('JUDUL BERITA SUDAH ADA');
                                                setTimeout(function() {
                                                    document.getElementById('error-alert').style.display = 'none';
                                                }, 5000);
                                            </script>
                                        <?php endif; ?>

                                        <div class="form-group">
                                            <label for="photo">Gambar</label>
                                            <div class="custom-file">
                                                <input type="file" name="photo" class="custom-file-input" accept=".jpg, .jpeg, .png" id="photo" required onchange="previewImage(event)">
                                                <label class="custom-file-label" for="photo" id="photoLabel">Pilih Gambar</label>
                                            </div>
                                            <div class="mt-3 d-flex align-items-center">
                                                <div style="width: 100px; height: 100px;">
                                                    <img id="imagePreview" style="width: 100%; height: 100%; object-fit: cover;" />
                                                </div>
                                                <button type="button" class="btn btn-danger ml-2" onclick="clearImage()">Hapus</button>
                                            </div>
                                        </div>

                                        <script>
                                            function previewImage(event) {
                                                var reader = new FileReader();
                                                reader.onload = function(){
                                                    var output = document.getElementById('imagePreview');
                                                    output.src = reader.result;
                                                    document.getElementById('photoLabel').innerText = 'Gambar Dipilih';
                                                };
                                                reader.readAsDataURL(event.target.files[0]);
                                            }

                                            function clearImage() {
                                                var fileInput = document.getElementById('photo');
                                                var imagePreview = document.getElementById('imagePreview');
                                                var photoLabel = document.getElementById('photoLabel');
                                                fileInput.value = '';
                                                imagePreview.src = '';
                                                photoLabel.innerText = 'Pilih Gambar';
                                            }
                                        </script>

                                        <div class="form-group">
                                            <label for="deskripsi">Deskripsi</label>
                                            <textarea style="height: 200px" type="text" class="form-control" id="deskripsi" name="deskripsi" placeholder="Masukkan deskripsi" required></textarea>
                                        </div>

                                        <div class="form-group">
                                            <label for="tags">Tag (pisah menggunakan tanda koma)</label>
                                            <input type="text" class="form-control" id="tags" name="tags" placeholder="Contoh UMKM, Pertanian, Ekonomi..." required>
                                        </div>

                                    </div>

                                    <div class="card-footer text-right">
                                        <button type="submit" class="btn btn-primary">Simpan</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
                <br>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\ROED\2025\UPTpasar_laravel\website\upt\resources\views/admin/create.blade.php ENDPATH**/ ?>