<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/font-awesome.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-gH2yIJqKdNHPEq0n4Mqa/HGKIhSkIHeL5AyhkYV8i59U5AR6csBvApHHNl/vI1Bx" crossorigin="anonymous">
    <style>
        .container {
            position: fixed;
            width: 400px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .back:hover {
            color: #4d82d2;
        }

        @media screen and (max-width:440px){
            .container {
                width: 90%;
            }
        }

    </style>
    <title>Diskumperindag || Login</title>
</head>
<body>
    <div class="container py-5">
        <div class="w-5 center border rounded px-3 py-3 mx-auto">
        <h1 class="text-center">LOGIN</h1>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <form action="<?php echo e(route('login')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" value="<?php echo e(old('username')); ?>" name="username" class="form-control" required>
            </div>
            <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <div class="input-group">
            <input type="password" name="password" id="password" class="form-control" required>
            <button type="button" class="btn border-0" id="togglePassword" style="outline: none;">
            <i class="fa fa-eye-slash" id="togglePasswordIcon"></i>
            </button>
            </div>
            </div>
            <div class="mb-3 d-grid">
            <button name="submit" type="submit" class="btn btn-primary">Login</button>
            <a href="/" class="back text-decoration-none m-3 text-center">Kembali ke Website</a>
            </div>
        </form>
        <script>
            document.getElementById('togglePassword').addEventListener('click', function () {
            const passwordField = document.getElementById('password');
            const passwordIcon = document.getElementById('togglePasswordIcon');
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            passwordIcon.classList.toggle('fa-eye');
            passwordIcon.classList.toggle('fa-eye-slash');
            });
        </script>
    </div>
    </div>
    <script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/js/bootsnav.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>
</body>
</html>
<?php /**PATH D:\ROED\2025\UPTpasar_laravel\website\upt\resources\views/login/login.blade.php ENDPATH**/ ?>